/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ACCircuitsAP
extends AP6 {
    static final String[][] text = new String[][]{{"de", "Einfache Wechselstromkreise", "Widerstand", "Kondensator", "Spule", "Zur\u00fcck", "Start", "Pause", "Weiter", "Zeitlupe", "Frequenz:", "Max. Spannung:", "Max. Stromst\u00e4rke:", "Widerstand:", "Kapazit\u00e4t:", "Induktivit\u00e4t:", "t", "T", "U", "I", ""}, {"en", "Simple AC Circuits", "Resistor", "Capacitor", "Coil", "Reset", "Start", "Pause", "Resume", "Slow motion", "Frequency:", "Max. voltage:", "Max. amperage:", "Resistance:", "Capacity:", "Inductivity:", "t", "T", "V", "I", ""}};
    private int[] gaps = new int[]{10, 5, 5, 10, 5, 10, 10, 5, 5, 5, 10, 5, 10};
    final int width = 700;
    final int height = 420;
    final int width0 = 420;
    CanvasAP cv;
    Panel6 pan;
    JLabel lbRCL;
    JLabel lbUnit;
    JLabel lbI0;
    JLabel lbUnitI;
    ResetButton buReset;
    StartButton buStart;
    JTextField tfNy;
    JTextField tfU0;
    JTextField tfRCL;
    JCheckBox cbSlow;
    JRadioButton rbR;
    JRadioButton rbC;
    JRadioButton rbL;
    Color bgCanvas;
    Color bgPanel;
    Color colorVoltage;
    Color colorAmperage;
    Color colorButton1;
    Color colorButton2;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    String text09;
    String text10;
    String text11;
    String text12;
    String text13;
    String text14;
    String symbolTime;
    String symbolPeriod;
    String symbolVoltage;
    String symbolAmperage;
    final double T0 = 5.0;
    final double PI = Math.PI;
    final double omega0 = 1.2566370614359172;
    boolean on;
    boolean slow;
    double t;
    double tD;
    double ny;
    double omega;
    double U0;
    double I0;
    double R;
    double C;
    double L;
    double phi;
    double psi;
    double dPhi;
    double eps = 1.0E-10;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(700, 420);
    }

    @Override
    protected void initAttributes() {
        this.slow = false;
        this.on = false;
        this.tD = 0.0;
        this.t = 0.0;
        this.ny = 50.0;
        this.omega = Math.PI * 2 * this.ny;
        this.U0 = 10.0;
        this.R = 500.0;
        this.C = 1.0E-4;
        this.L = 200.0;
        this.dPhi = 0.0;
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorButton1 = this.getColor(Color.cyan, "colorButton1");
        this.colorButton2 = this.getColor(Color.yellow, "colorButton2");
        this.colorVoltage = this.getColor(Color.blue, "colorVoltage");
        this.colorAmperage = this.getColor(Color.red, "colorAmperage");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.text09 = this.getText(t[10], "text09");
        this.text10 = this.getText(t[11], "text10");
        this.text11 = this.getText(t[12], "text11");
        this.text12 = this.getText(t[13], "text12");
        this.text13 = this.getText(t[14], "text13");
        this.text14 = this.getText(t[15], "text14");
        this.symbolTime = this.getText(t[16], "symbolTime");
        this.symbolPeriod = this.getText(t[17], "symbolPeriod");
        this.symbolVoltage = this.getText(t[18], "symbolVoltage");
        this.symbolAmperage = this.getText(t[19], "symbolAmperage");
        this.coauthor = this.getText(t[20], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 420, 420);
        this.add(this.cv);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(420, 0, 280, 420);
        ButtonGroup bg = new ButtonGroup();
        this.rbR = new JRadioButton(this.text01, true);
        bg.add(this.rbR);
        this.pan.add(this.rbR, this.bgPanel, Color.black);
        this.rbC = new JRadioButton(this.text02, false);
        bg.add(this.rbC);
        this.pan.add(this.rbC, this.bgPanel, Color.black);
        this.rbL = new JRadioButton(this.text03, false);
        bg.add(this.rbL);
        this.pan.add(this.rbL, this.bgPanel, Color.black);
        this.buReset = new ResetButton(this.text04);
        this.pan.add(this.buReset, this.colorButton1, Color.black);
        this.buStart = new StartButton(this.text05, this.text06, this.text07);
        this.pan.add(this.buStart, this.colorButton2, Color.black);
        this.cbSlow = new JCheckBox(this.text08, false);
        this.pan.add(this.cbSlow, this.bgPanel, Color.black);
        this.tfNy = this.pan.newInputField(this.text09, this.hertz, this.bgPanel, Color.black, 1);
        int h = this.tfNy.getPreferredSize().height;
        this.tfNy.setMinimumSize(new Dimension(40, h));
        this.tfNy.setText(this.toString2(this.ny, 3, this.eps));
        this.tfU0 = this.pan.newInputField(this.text10, this.volt, this.bgPanel, Color.black, 1);
        this.tfU0.setText(this.toString2(this.U0, 3, this.eps));
        this.lbRCL = new JLabel(this.text12);
        this.pan.add(this.lbRCL, this.bgPanel, 0, 1, 10, 0);
        this.tfRCL = new JTextField(5);
        this.tfRCL.setText(this.toString2(this.R, 3, this.eps));
        this.pan.add(this.tfRCL, Color.white, 1, 1, 0, 0);
        this.lbUnit = new JLabel(this.ohm);
        this.pan.add(this.lbUnit, this.bgPanel, 2, 1, 5, 10);
        this.pan.add(new JLabel(this.text11), this.bgPanel, 0, 1, 10, 0);
        this.lbI0 = new JLabel("___");
        this.pan.add(this.lbI0, Color.pink, 1, 1, 0, 0);
        this.lbUnitI = new JLabel("___");
        this.pan.add(this.lbUnitI, Color.red, 2, 1, 5, 10);
        this.pan.add(1998);
        this.pan.add(this.coauthor);
        this.calculation();
        this.add(this.pan);
        this.rbR.addActionListener(this);
        this.rbC.addActionListener(this);
        this.rbL.addActionListener(this);
        this.buReset.addActionListener(this);
        this.buStart.addActionListener(this);
        this.cbSlow.addActionListener(this);
        this.tfNy.addActionListener(this);
        this.tfU0.addActionListener(this);
        this.tfRCL.addActionListener(this);
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            if (this.on) {
                this.cv.repaint();
            }
            try {
                Thread.sleep(this.on ? 50L : 100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            if (this.on) {
                double dt = (double)(t1 - t0) / 1000.0;
                if (this.slow) {
                    dt /= 5.0;
                }
                this.t += dt;
                this.tD += dt;
                int n = (int)(this.tD / 15.0);
                this.tD -= (double)(n * 3) * 5.0;
            }
            t0 = t1;
        }
    }

    void calculation() {
        String unit;
        String number;
        this.omega = Math.PI * 2 * this.ny;
        this.I0 = this.dPhi == 0.0 ? this.U0 / this.R : (this.dPhi > 0.0 ? this.U0 * this.omega * this.C : this.U0 / (this.omega * this.L));
        if (this.I0 > 1.0) {
            number = this.toString2(this.I0, 3, this.eps);
            unit = this.ampere;
        } else if (this.I0 > 0.001) {
            number = this.toString2(this.I0 * 1000.0, 3, this.eps);
            unit = this.milliampere;
        } else {
            number = this.toString2(this.I0 * 1000000.0, 3, this.eps);
            unit = this.microampere;
        }
        this.lbI0.setText(number);
        this.lbUnitI.setText(unit);
    }

    void changeValues() {
        this.ny = this.inputTF(this.tfNy, 0.1, 100.0, 3);
        this.U0 = this.inputTF(this.tfU0, 0.1, 100.0, 3);
        if (this.dPhi == 0.0) {
            this.R = this.inputTF(this.tfRCL, 10.0, 1000.0, 3);
        } else if (this.dPhi > 0.0) {
            this.C = this.inputTF(this.tfRCL, 1.0, 100.0, 3);
            this.C *= 1.0E-6;
        } else {
            this.L = this.inputTF(this.tfRCL, 10.0, 1000.0, 3);
        }
        this.calculation();
    }

    void enableCBTF(boolean flag) {
        this.rbR.setEnabled(flag);
        this.rbC.setEnabled(flag);
        this.rbL.setEnabled(flag);
        this.tfNy.setEnabled(flag);
        this.tfU0.setEnabled(flag);
        this.tfRCL.setEnabled(flag);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.changeValues();
        Object o = ae.getSource();
        if (o == this.buReset) {
            this.buStart.setState(0);
            this.enableCBTF(true);
            this.tD = 0.0;
            this.t = 0.0;
        } else if (o == this.buStart) {
            this.buStart.setState();
            this.enableCBTF(false);
        } else if (o == this.rbR) {
            this.lbRCL.setText(this.text12);
            this.lbUnit.setText(this.ohm);
            this.dPhi = 0.0;
            this.R = 500.0;
            this.tfRCL.setText(this.toString2(this.R, 3, this.eps));
        } else if (o == this.rbC) {
            this.lbRCL.setText(this.text13);
            this.lbUnit.setText(this.microfarad);
            this.dPhi = 1.5707963267948966;
            this.C = 1.0E-4;
            this.tfRCL.setText(this.toString2(this.C * 1000000.0, 3, this.eps));
        } else if (o == this.rbL) {
            this.lbRCL.setText(this.text14);
            this.lbUnit.setText(this.henry);
            this.dPhi = -1.5707963267948966;
            this.L = 200.0;
            this.tfRCL.setText(this.toString2(this.L, 3, this.eps));
        }
        this.on = this.buStart.getState() == 1;
        this.slow = this.cbSlow.isSelected();
        this.calculation();
        if (!this.on) {
            this.cv.repaint();
        }
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, ACCircuitsAP.this.bgCanvas);
        }

        void meter(Graphics2D g, int x, int y, int type, double part) {
            double w = part * 0.2 * Math.PI;
            double x1 = (double)x + 35.0 * Math.sin(w);
            double y1 = (double)y - 35.0 * Math.cos(w);
            CanvasAP.rectangle(g, x - 30, y - 50, 60.0, 40.0, Color.white, true);
            CanvasAP.line(g, 2.0, x, y, x1, y1);
            for (int i = -2; i <= 2; ++i) {
                if (i == 0) continue;
                double ww = (double)i * 0.1 * Math.PI;
                double sin = Math.sin(ww);
                double cos = Math.cos(ww);
                int r1 = 38;
                int r2 = i % 2 == 0 ? 45 : 43;
                x1 = (double)x + (double)r1 * sin;
                y1 = (double)y - (double)r1 * cos;
                double x2 = (double)x + (double)r2 * sin;
                double y2 = (double)y - (double)r2 * cos;
                CanvasAP.line(g, 2.0, x1, y1, x2, y2);
            }
            Color c = type == 0 ? ACCircuitsAP.this.colorVoltage : ACCircuitsAP.this.colorAmperage;
            CanvasAP.rectangle(g, x - 30, y - 10, 60.0, 20.0, c, true);
            CanvasAP.circle(g, x - 15, y, 3.0, Color.black, true);
            CanvasAP.circle(g, x + 15, y, 3.0, Color.black, true);
            CanvasAP.setAntiAliasing(g, false);
            this.alignText(g, "0", this.fH, 1, x, y - 38);
            String u = type == 0 ? ACCircuitsAP.this.volt : ACCircuitsAP.this.ampere;
            this.alignText(g, u, this.fH, 1, x, y + 5);
            CanvasAP.setAntiAliasing(g, true);
        }

        void resistor(Graphics g) {
            g.setColor(Color.black);
            g.fillRect(55, 65, 85, 30);
            g.setColor(ACCircuitsAP.this.bgCanvas);
            g.fillRect(58, 68, 79, 24);
        }

        void condensator(Graphics2D g) {
            g.setColor(Color.black);
            g.fillRect(88, 60, 5, 40);
            g.fillRect(102, 60, 5, 40);
            CanvasAP.line(g, 2.0, 55.0, 80.0, 90.0, 80.0);
            CanvasAP.line(g, 2.0, 105.0, 80.0, 140.0, 80.0);
        }

        void coil(Graphics2D g) {
            g.setColor(Color.black);
            double x0 = 55.0;
            double y0 = 80.0;
            for (int i = 0; i <= 150; ++i) {
                double w = (double)i * Math.PI / 10.0;
                double x1 = i < 10 ? 55.0 + 1.5 * (double)i : (i >= 10 && i <= 140 ? 60.0 + 0.5 * (double)i - 5.0 * Math.cos(w) : 1.5 * (double)i - 85.0);
                double y1 = 80.0 - 15.0 * Math.sin(w);
                CanvasAP.line(g, 2.0, x0, y0, x1, y1);
                x0 = x1;
                y0 = y1;
            }
        }

        void circuit(Graphics2D g) {
            double sinPhi = Math.sin(ACCircuitsAP.this.phi);
            double sinPsi = Math.sin(ACCircuitsAP.this.psi);
            this.meter(g, 210, 150, 0, sinPhi);
            this.meter(g, 300, 80, 1, sinPsi);
            if (ACCircuitsAP.this.dPhi == 0.0) {
                this.resistor(g);
            } else if (ACCircuitsAP.this.dPhi > 0.0) {
                this.condensator(g);
            } else {
                this.coil(g);
            }
            CanvasAP.circle(g, 193.0, 200.0, 4.0, Color.black, true);
            CanvasAP.circle(g, 193.0, 200.0, 3.0, ACCircuitsAP.this.bgCanvas, true);
            CanvasAP.circle(g, 227.0, 200.0, 4.0, Color.black, true);
            CanvasAP.circle(g, 227.0, 200.0, 3.0, ACCircuitsAP.this.bgCanvas, true);
            g.setFont(new Font("Monospaced", 1, 24));
            g.drawString("~", 204, 210);
            g.setFont(this.fH);
            CanvasAP.line(g, 2.0, 30.0, 200.0, 190.0, 200.0);
            CanvasAP.line(g, 2.0, 230.0, 200.0, 390.0, 200.0);
            CanvasAP.line(g, 2.0, 30.0, 150.0, 190.0, 150.0);
            CanvasAP.line(g, 2.0, 230.0, 150.0, 390.0, 150.0);
            CanvasAP.line(g, 2.0, 30.0, 80.0, 55.0, 80.0);
            CanvasAP.line(g, 2.0, 140.0, 80.0, 285.0, 80.0);
            CanvasAP.line(g, 2.0, 315.0, 80.0, 390.0, 80.0);
            CanvasAP.line(g, 2.0, 30.0, 200.0, 30.0, 80.0);
            CanvasAP.line(g, 2.0, 390.0, 200.0, 390.0, 80.0);
            CanvasAP.circle(g, 30.0, 150.0, 3.0, Color.black, true);
            CanvasAP.circle(g, 390.0, 150.0, 3.0, Color.black, true);
            if (Math.abs(sinPhi) > 0.05) {
                CanvasAP.rectangle(g, 188.0, 184.0, 10.0, 2.0, Color.black, true);
                CanvasAP.rectangle(g, 222.0, 184.0, 10.0, 2.0, Color.black, true);
                if (sinPhi > 0.0) {
                    CanvasAP.rectangle(g, 226.0, 180.0, 2.0, 10.0, Color.black, true);
                } else {
                    CanvasAP.rectangle(g, 192.0, 180.0, 2.0, 10.0, Color.black, true);
                }
            }
            if (sinPsi > 0.05) {
                CanvasAP.arrow(g, 2.0, 220.0, 70.0, 200.0, 70.0);
            } else if (sinPsi < -0.05) {
                CanvasAP.arrow(g, 2.0, 200.0, 70.0, 220.0, 70.0);
            }
        }

        void pointerDiagram(Graphics2D g, int x, int y) {
            g.setColor(Color.black);
            CanvasAP.arrow(g, x - 60, y, x + 70, y);
            CanvasAP.arrow(g, x, y + 60, x, y - 70);
            g.setColor(ACCircuitsAP.this.colorVoltage);
            double x1 = (double)x + 50.0 * Math.cos(ACCircuitsAP.this.phi);
            double y1 = (double)y - 50.0 * Math.sin(ACCircuitsAP.this.phi);
            CanvasAP.arrow(g, 2.0, x, y, x1, y1);
            if (y1 != (double)y) {
                CanvasAP.line(g, x - 60, y1, 390.0, y1);
            }
            g.setColor(ACCircuitsAP.this.colorAmperage);
            x1 = (double)x + 35.0 * Math.cos(ACCircuitsAP.this.psi);
            y1 = (double)y - 35.0 * Math.sin(ACCircuitsAP.this.psi);
            CanvasAP.arrow(g, 2.0, x, y, x1, y1);
            if (y1 != (double)y) {
                CanvasAP.line(g, x - 60, y1, 390.0, y1);
            }
        }

        void drawSinus(Graphics2D g, double x, double y, double per, double ampl, double xMin, double xMax, double xP) {
            double k = Math.PI * 2 / per;
            double x0 = xMin;
            double y0 = y - ampl * Math.sin(k * (x0 - x));
            while (x0 < xMax) {
                double x1 = x0 + 1.0;
                double y1 = y - ampl * Math.sin(k * (x1 - x));
                CanvasAP.line(g, x0, y0, x1, y1);
                x0 = x1;
                y0 = y1;
            }
            if (xP < xMin || xP > xMax) {
                return;
            }
            double yP = y - ampl * Math.sin(k * (xP - x));
            Color c = g.getColor();
            if (xP >= 0.0) {
                CanvasAP.circle(g, xP, yP, 2.0, c, true);
            }
            g.setColor(c);
        }

        void tUIDiagram(Graphics2D g, int x, int y) {
            g.setColor(Color.black);
            CanvasAP.arrow(g, x - 10, y, x + 200, y);
            CanvasAP.arrow(g, x, y + 60, x, y - 70);
            g.drawString(ACCircuitsAP.this.symbolTime, x + 195, y + 14);
            double xx = (double)x + 60.0 * ACCircuitsAP.this.tD / 5.0;
            g.setColor(ACCircuitsAP.this.colorVoltage);
            this.drawSinus(g, x, y, 60.0, 50.0, x, x + 180, xx);
            this.alignText(g, ACCircuitsAP.this.symbolVoltage, this.fH, 2, x - 5, y - 65);
            g.setColor(ACCircuitsAP.this.colorAmperage);
            int xSin = x;
            if (ACCircuitsAP.this.dPhi > 0.0) {
                xSin = x - 15;
            } else if (ACCircuitsAP.this.dPhi < 0.0) {
                xSin = x + 15;
            }
            this.drawSinus(g, xSin, y, 60.0, 35.0, x, x + 180, xx);
            this.alignText(g, ACCircuitsAP.this.symbolAmperage, this.fH, 0, x + 5, y - 65);
            g.setColor(Color.black);
            String periode = ACCircuitsAP.this.symbolPeriod;
            for (int i = 1; i <= 3; ++i) {
                int xT = x + i * 60;
                CanvasAP.line(g, xT, y - 2, xT, y + 2);
                String number = i > 1 ? "" + i : "";
                this.alignText(g, number + periode, this.fH, 1, xT, y + 14);
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            g.setFont(this.fH);
            ACCircuitsAP.this.phi = 1.2566370614359172 * ACCircuitsAP.this.t;
            ACCircuitsAP.this.psi = ACCircuitsAP.this.phi + ACCircuitsAP.this.dPhi;
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            this.circuit(g2);
            this.pointerDiagram(g2, 90, 330);
            this.tUIDiagram(g2, 190, 330);
        }
    }
}

